#!/usr/bin/env python


"""Distutils distribution file"""


from setuptools import setup, find_packages

import game.common
import sys

if sys.argv[1] == 'install':
    print '** Do not install from setup.py. Just run the game by typing "python tower.py"'
    sys.exit(1)

setup(name='exogene',
      version=game.common.version,
      scripts=['exogene.py'], 
      entry_points = {
        'console_scripts' : [
            'exogene = exogene.exogene',
        ]
      },      
      description='A tower defence type game with multiple waves of enemies attacking multiple points to defend.',
      author='Paul Paterson',
      author_email='ppaterson@gmail.com',
      url='http://perpetualpyramid.com/drupal/exogene_game',
      download_url=('http://perpetualpyramid.com/exogene-%s.tar.gz' % game.common.version),

      include_package_data=True,
      zip_safe=False,

      packages=[
        'serge', 'serge.blocks', 'serge.tools', 'serge.tools.template', 'game',
      ],
      package_dir={'':'.'},

      classifiers = [
        "Programming Language :: Python",
        "Programming Language :: Python :: 2",
        "Development Status :: 4 - Beta",
        "Environment :: Other Environment",
        "Intended Audience :: End Users/Desktop",
        "License :: OSI Approved :: GNU Library or Lesser General Public License (LGPL)",
        "Operating System :: OS Independent",
        "Topic :: Games/Entertainment",
        "Topic :: Games/Entertainment :: Puzzle Games",
        ],
       install_requires=[
       # 'pygame', 'networkx', 'pymunk',
       ],
       long_description='''\
Exogene
-------

A tower defence type game with multiple points of attack to defend.

Place towers strategically to defend against the waves of enemies. Watch
out for the enemies attacking multiple points.

Requires: Python 2.6+, networkx and pygame 1.9+

''',
         )
     
